import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/blocs/config_bloc.dart';
import 'package:wordpress_app/cards/card1.dart';
import 'package:wordpress_app/cards/card4.dart';
import 'package:wordpress_app/models/article.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:wordpress_app/widgets/inline_ads.dart';
import '../blocs/latest_articles_bloc.dart';
import 'loading_indicator_widget.dart';

class LattestArticles extends ConsumerWidget {
  const LattestArticles({super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final articles = ref.watch(latestArticlesBlocProvider).articles;
    final configs = ref.read(configBlocProvider).configs!;
    final isLoading = ref.watch(latestArticlesBlocProvider).loading;

    return SliverPadding(
      padding: EdgeInsets.zero,
      sliver: SliverList(
        delegate: SliverChildBuilderDelegate(
          (context, index) {
            if (index == 0) {
              return Container(
                alignment: Alignment.centerLeft,
                padding: const EdgeInsets.only(
                    left: 20, right: 20, top: 40, bottom: 10),
                child: Text(
                  'recent-contents'.tr(),
                  style: Theme.of(context)
                      .textTheme
                      .headlineSmall
                      ?.copyWith(fontWeight: FontWeight.w700),
                ),
              );
            }

            if (articles.isEmpty) {
              if (index == 1) {
                return Opacity(
                  opacity: isLoading == true ? 1.0 : 0.0,
                  child: const LoadingIndicatorWidget(),
                );
              }
              return const SizedBox.shrink();
            }

            final articleIndex = index - 1;
            if (articleIndex < articles.length) {
              final Article article = articles[articleIndex];
              final bool showAd =
                  (articleIndex + 1) % configs.postIntervalCount == 0;

              // Pattern: first 4 items Card4, then 3 items Card1, repeat
              // Cycle is 7 items (0-3: Card4, 4-6: Card1)
              final positionInCycle = articleIndex % 7;
              final bool useCard1 = positionInCycle >= 4;

              return Padding(
                padding: EdgeInsets.only(
                  left: 15,
                  right: 15,
                  top: articleIndex > 0 ? 0 : 0,
                  bottom: 0,
                ),
                child: Column(
                  children: [
                    if (articleIndex > 0) const Divider(height: 40),
                    if (showAd)
                      Column(
                        children: [
                          useCard1
                              ? Card1(
                                  article: article,
                                  heroTag: 'latest-${article.id}')
                              : Card4(
                                  article: article,
                                  heroTag: 'latest-${article.id}'),
                          const Divider(height: 20),
                          const InlineAds(),
                        ],
                      )
                    else
                      useCard1
                          ? Card1(
                              article: article,
                              heroTag: 'latest1-${article.id}')
                          : Card4(
                              article: article,
                              heroTag: 'latest1-${article.id}'),
                  ],
                ),
              );
            }

            if (index == articles.length + 1) {
              return Opacity(
                opacity: isLoading == true ? 1.0 : 0.0,
                child: const LoadingIndicatorWidget(),
              );
            }

            return const SizedBox.shrink();
          },
          childCount: articles.isEmpty ? 2 : articles.length + 2,
        ),
      ),
    );
  }
}
